choiceBMT = {}

local af = Def.ActorFrame{
	InitCommand=function(self)
		self:visible(false):diffusealpha(0):z(999)
			:xy(_screen.cx, _screen.h-50)
		SRT.Dialog.Box = self
	end,
	ShowCommand=function(self) self:visible(true):linear(0.333):diffusealpha(1) end,
	HideCommand=function(self)
		SRT.Dialog.Index = 1
		SRT.Dialog.BoxColor = nil
		SRT.InputIsLocked = false
		SRT.DialogIsActive = false
		self:visible(false)
	end,


	Def.ActorFrame{
		InitCommand=function(self)
			self:zoom(0.2)
		end,
		LoadActor(THEME:GetPathB("Intro", "overlay/box.png")),
		LoadActor(THEME:GetPathB("Intro", "overlay/box_stroke.png"))..{
			InitCommand=function(self)
				self:diffuse(color("#777777"))
			end,
			UpdateColorCommand=function(self, params)
				self:diffuse(params.Color)
			end
		},
	},

	-- the speaker's name
	Def.ActorFrame{
		Name="NameBoxAF",
		InitCommand=function(self)
			self:visible(false):zoom(0.75)
			self:xy(-196, -40)
		end,
		ClearTextCommand=function(self)
			self:visible(false)
		end,
		UpdateTextCommand=function(self)
			self:visible(false)

			if SRT.Dialog.Speaker and SRT.Dialog.Speaker ~= "" then
				self:visible( true )
			end
		end,

		-- name box stroke
		Def.Quad{
			Name="Stroke",
			InitCommand=function(self)
				self:zoomto(104,36):diffuse(0.1,0.1,0.1,1)
			end
		},
		-- name box
		Def.Quad{
			Name="Box",
			InitCommand=function(self)
				self:zoomto(100,32)
			end,
			UpdateColorCommand=function(self, params)
				if not params.Color then
					self:diffuse("#444444")
				else
					self:diffuse(params.Color)
				end
			end
		},

		--name
		Def.BitmapText{
			Font="Common normal",
			ClearTextCommand=function(self)
				self:settext("")
			end,
			UpdateSpeakerCommand=function(self)
				self:playcommand("UpdateText")
			end,
			UpdateTextCommand=function(self)
				if SRT.Dialog.Speaker and SRT.Dialog.Speaker ~= "" then
					self:settext( SRT.Dialog.Speaker )
				end
			end,

		}
	},



	Def.BitmapText{
		Name="Text",
		Font="Common normal",
		InitCommand=function(self) self:zoom(0.7) end,
		OnCommand=function(self)
			self:halign(0):valign(0):xy(-_screen.w/3, -24)
				:diffuse(Color.Black):wrapwidthpixels(_screen.w * 0.95)
		end,
		ClearTextCommand=function(self)
			self:settext(""):cropright(1)
		end,
		UpdateTextCommand=function(self)
			SRT.Dialog.IsTweening = true


			if type(SRT.Dialog.Words[SRT.Dialog.Index].text) == "string" then
				text = SRT.Dialog.Words[SRT.Dialog.Index].text
			elseif type(SRT.Dialog.Words[SRT.Dialog.Index].text) == "function" then
				text = SRT.Dialog.Words[SRT.Dialog.Index].text()
			end

			if text then
				self:settext( text ):linear(0.75):cropright(0):queuecommand("FinishUpdateText")
			else
				self:queuecommand("ClearText")
			end
		end,
		FinishUpdateTextCommand=function(self) SRT.Dialog.IsTweening = false end
	}
}

---------------------------------------------------------------------------------------------
-- Cursor

af[#af+1] = Def.ActorFrame{
	InitCommand=function(self)
		SRT.Dialog.Cursor = self
		self:visible(false):y(12)
	end,

	ClearTextCommand=function(self)
		self:visible(false)
	end,
	UpdateTextCommand=function(self)
		self:diffusealpha(0)

		if SRT.Dialog.Words[SRT.Dialog.Index].choices then
			SRT.Dialog.ChoiceIndex = 1
			self:queuecommand("UpdateCursor")
			self:visible(true):sleep(1):linear(0.2):diffusealpha(1)
		end
	end,

	Def.Quad{
		InitCommand=function(self)
			self:diffuse(color("#8563c6")):xy(-_screen.w/3, 2):halign(0)
		end,
		UpdateCursorCommand=function(self)
			if SRT.Dialog.Words[SRT.Dialog.Index].choices then

				local char_width = 11

				self:zoomto( choiceBMT[SRT.Dialog.ChoiceIndex]:GetText():len() * char_width - 4, 18 )
					:x( choiceBMT[SRT.Dialog.ChoiceIndex]:GetX()-4 )
			end
		end
	},
}

---------------------------------------------------------------------------------------------
-- Choice BitmapTexts

for i=1,3 do
	af[#af+1] = Def.BitmapText{
		Font="Common normal",
		InitCommand=function(self)
			choiceBMT[i] = self
			self:zoom(0.7)
		end,
		OnCommand=function(self)
			self:halign(0):xy(((_screen.w/4)*i)-_screen.w/1.75, 14):diffuse(Color.Black)
		end,
		ClearTextCommand=function(self)
			self:settext(""):diffusealpha(0)
		end,
		UpdateTextCommand=function(self)
			if SRT.Dialog.Words[SRT.Dialog.Index].choices and SRT.Dialog.Words[SRT.Dialog.Index].choices[i] then
				self:settext( SRT.Dialog.Words[SRT.Dialog.Index].choices[i] ):sleep(1):linear(0.75):diffusealpha(1)
			end
		end
	}
end

return af